<?php
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}

require_once '../api/config.php';

$db = getDB();

// Get statistics
$stats = $db->query("
    SELECT 
        COUNT(DISTINCT place_id) as total_places,
        COUNT(*) as total_paths,
        SUM(downloads) as total_downloads,
        SUM(file_size) as total_size
    FROM paths
")->fetch();

// Get recent uploads
$recent = $db->query("
    SELECT * FROM paths 
    ORDER BY upload_date DESC 
    LIMIT 20
")->fetchAll();

// Handle delete
if (isset($_POST['delete_id'])) {
    $id = $_POST['delete_id'];
    $path = $db->prepare("SELECT file_path FROM paths WHERE id = ?")->execute([$id]);
    $path = $db->query("SELECT file_path FROM paths WHERE id = " . intval($id))->fetch();
    
    if ($path) {
        @unlink(UPLOAD_DIR . $path['file_path']);
        $db->prepare("DELETE FROM paths WHERE id = ?")->execute([$id]);
    }
    header('Location: dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Motion Path Admin</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f6fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h1 { font-size: 24px; }
        .navbar a {
            color: white;
            text-decoration: none;
            padding: 8px 15px;
            background: rgba(255,255,255,0.2);
            border-radius: 5px;
            transition: background 0.3s;
        }
        .navbar a:hover { background: rgba(255,255,255,0.3); }
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 30px;
        }
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .stat-card h3 {
            color: #666;
            font-size: 14px;
            margin-bottom: 10px;
            text-transform: uppercase;
        }
        .stat-card .value {
            font-size: 32px;
            font-weight: bold;
            color: #667eea;
        }
        .section {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        .section h2 {
            margin-bottom: 20px;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #e1e1e1;
        }
        th {
            background: #f8f9fa;
            font-weight: 600;
            color: #666;
            text-transform: uppercase;
            font-size: 12px;
        }
        .badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 600;
        }
        .badge-checkpoint { background: #ffeaa7; color: #d63031; }
        .badge-main { background: #dfe6e9; color: #2d3436; }
        .btn-delete {
            background: #ff4757;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
        }
        .btn-delete:hover { background: #ee5a6f; }
        .search-box {
            margin-bottom: 20px;
        }
        .search-box input {
            width: 100%;
            padding: 12px;
            border: 2px solid #e1e1e1;
            border-radius: 5px;
            font-size: 14px;
        }
        .empty {
            text-align: center;
            padding: 40px;
            color: #999;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h1>🎮 Motion Path Admin</h1>
        <div>
            <span style="margin-right: 20px;">👤 <?= htmlspecialchars($_SESSION['admin_username']) ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>
    
    <div class="container">
        <div class="stats">
            <div class="stat-card">
                <h3>Total Places</h3>
                <div class="value"><?= number_format($stats['total_places']) ?></div>
            </div>
            <div class="stat-card">
                <h3>Total Paths</h3>
                <div class="value"><?= number_format($stats['total_paths']) ?></div>
            </div>
            <div class="stat-card">
                <h3>Total Downloads</h3>
                <div class="value"><?= number_format($stats['total_downloads']) ?></div>
            </div>
            <div class="stat-card">
                <h3>Storage Used</h3>
                <div class="value"><?= round($stats['total_size'] / 1024 / 1024, 2) ?> MB</div>
            </div>
        </div>
        
        <div class="section">
            <h2>📁 Recent Uploads</h2>
            
            <div class="search-box">
                <input type="text" id="searchInput" placeholder="Search by Place ID, uploader name..." onkeyup="searchTable()">
            </div>
            
            <?php if (empty($recent)): ?>
                <div class="empty">No data yet</div>
            <?php else: ?>
                <table id="pathsTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Place ID</th>
                            <th>Version</th>
                            <th>Type</th>
                            <th>Uploader</th>
                            <th>Size</th>
                            <th>Downloads</th>
                            <th>Upload Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recent as $path): ?>
                        <tr>
                            <td><?= $path['id'] ?></td>
                            <td><strong><?= $path['place_id'] ?></strong></td>
                            <td>v<?= $path['map_version'] ?></td>
                            <td>
                                <?php if ($path['is_checkpoint']): ?>
                                    <span class="badge badge-checkpoint">CP #<?= $path['checkpoint_index'] ?></span>
                                <?php else: ?>
                                    <span class="badge badge-main">Main</span>
                                <?php endif; ?>
                            </td>
                            <td><?= htmlspecialchars($path['uploader_name']) ?></td>
                            <td><?= round($path['file_size'] / 1024, 1) ?> KB</td>
                            <td><?= $path['downloads'] ?></td>
                            <td><?= date('d M Y H:i', strtotime($path['upload_date'])) ?></td>
                            <td>
                                <form method="POST" style="display:inline;" onsubmit="return confirm('Delete this path?')">
                                    <input type="hidden" name="delete_id" value="<?= $path['id'] ?>">
                                    <button type="submit" class="btn-delete">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        function searchTable() {
            const input = document.getElementById('searchInput');
            const filter = input.value.toUpperCase();
            const table = document.getElementById('pathsTable');
            const tr = table.getElementsByTagName('tr');
            
            for (let i = 1; i < tr.length; i++) {
                const td = tr[i].getElementsByTagName('td');
                let found = false;
                
                for (let j = 0; j < td.length; j++) {
                    if (td[j]) {
                        const txtValue = td[j].textContent || td[j].innerText;
                        if (txtValue.toUpperCase().indexOf(filter) > -1) {
                            found = true;
                            break;
                        }
                    }
                }
                
                tr[i].style.display = found ? '' : 'none';
            }
        }
    </script>
</body>
</html>
