<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'motion_paths');
define('DB_USER', 'root');  // Ganti dengan user MySQL kamu
define('DB_PASS', '');      // Ganti dengan password MySQL kamu

// API Configuration
define('API_KEY', 'motion_api_key_2024_secure_token_change_this'); // Ganti dengan key yang aman!

// File Upload Configuration
define('UPLOAD_DIR', __DIR__ . '/../uploads/paths/');
define('MAX_FILE_SIZE', 100 * 1024 * 1024); // 100MB max
define('ALLOWED_EXTENSIONS', ['json']);

// Security
define('ENABLE_API_KEY_CHECK', true);
define('ENABLE_CORS', true);

// Timezone
date_default_timezone_set('Asia/Jakarta');

// Create upload directory if not exists
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}

// Database Connection
function getDB() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            $pdo = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch (PDOException $e) {
            die(json_encode(['error' => 'Database connection failed']));
        }
    }
    return $pdo;
}

// CORS Headers
if (ENABLE_CORS) {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-API-Key');
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit;
    }
}

header('Content-Type: application/json');
?>
